<!-- Banner -->
<section id="banner">
    <div class="content">
        <header>
            <h2>Multi-Rater Competency Feedback</h2>
            <p>More than just one person's random opinions!</p>
            <p>Avoid the surprise; take charge of your development.</p>
        </header>
        <span class="image"><img src="/static/images/pic01.jpg" alt="" /></span>
    </div>
    <a href="#one" class="goto-next scrolly">Next</a>
</section>

<!-- One -->
<section id="one" class="spotlight style1 bottom">
    <span class="image fit main"><img src="/static/images/pic02.jpg" alt="" /></span>
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="4u 12u$(medium)">
                    <header>
                        <h2>Driven by Qualitative &amp; Contextual Feedback</h2>
                        <p>Collect Feedback from everyone that matters, as frequently as you desire.</p>
                    </header>
                </div>
                <div class="4u 12u$(medium)">
                    <p>Don't wait for your annual feedback cycle and be caught by surprise. Self-rate yourself on important workplace competencies and then ask your team (manager, peers, direct reports and collaborators from other teams) to rate you as well. Use this tool to pull feedback rather than waiting for it to be pushed to you.</p>
                </div>
                <div class="4u$ 12u$(medium)">
                    <p>Its anonymous, so that everyone can feel comfortable giving you honest and open feedback. You might not always agree with what you see in the feedback, but use it as an opportunity to see how you can get others to see from your perspective.</p>
                </div>
            </div>
        </div>
    </div>
    <a href="#two" class="goto-next scrolly">Next</a>
</section>

<!-- Two -->
<section id="two" class="spotlight style2 right">
    <span class="image fit main"><img src="/static/images/pic03.jpg" alt="" /></span>
    <div class="content">
        <header>
            <h2>Career is a Long Journey; Are you Ready?</h2>
            <p>Frequent, high quality feedback will equip you to Inspect &amp; Adapt toward a better, more enjoyable career path.</p>
        </header>
        <p><a href="http://en.wikipedia.org/wiki/360-degree_feedback#cite_note-12" target="_blank">Several studies</a> indicate that the use of 360-degree feedback helps to improve employee performance because it helps the evaluated see different perspectives of their performance.</p>
        <p>Use 360&deg; Feedback to fill perception gaps. Its important for us to notice (even minor) gaps between how we think we are performing and how others see it.</p>
        <ul class="actions">
            <li><a href="http://en.wikipedia.org/wiki/360-degree_feedback" class="button" target="_blank">Learn More</a></li>
        </ul>
    </div>
    <a href="#three" class="goto-next scrolly">Next</a>
</section>

<!-- Three -->
<section id="three" class="spotlight style3 left">
    <span class="image fit main bottom"><img src="/static/images/pic04.jpg" alt="" /></span>
    <div class="content">
        <header>
            <h2>Scale and Sustain</h2>
            <p>Identifying top performers and grooming them to reach new heights is key to every organisation's success.</p>
        </header>
        <p>A 360&deg; feedback tool is only the first step in the direction. Ensuring quality feedback is provided to every employee, early enough is important for better growth.
            Employees can use the feedback to identify how they are successfully communicating their strengths (and weaknesses) and where they could focus to improve those communications.</p>
        <p>Use 360&deg; feedback as a catalyst for team bonding and personal development via collaboration.</p>
    </div>
    <a href="#make_it_work" class="goto-next scrolly">Next</a>
</section>

<section id="make_it_work" class="spotlight style1 bottom">
    <span class="image fit main"><img src="/static/images/team.jpg" alt="" /></span>
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="4u 12u$(medium)">
                    <header>
                        <h2>Make 360 Feedback Work</h2>
                        <p>Get everyone's buy-in via a collaborative discussion before you roll this out.</p>
                    </header>
                    <p>In many companies, managers simply send out an email to all the team members to participate in 360 Feedback. Alas! the participation is very poor or half-hearted. Don't make the same mistake.</p>
                </div>
                <div class="4u 12u$(medium)">
                    <p>Before rolling out 360 Feedback, first have an open discussion about the problems with the current feedback &amp; review system. And then explain how 360 Feedback can really address some of those issue. Get the team's buy-in to ensure they will give their best shot.</p>
                    <p>Use the following steps to roll-out an effective 360 Feedback in your team:</p>
                </div>
                <div class="4u$ 12u$(medium)">
                    <ol>
                        <li>From the overall list of competencies, as a team, decide which 5-7 competencies matters the most to your team</li>
                        <li>Discuss a few examples of how to give effective feedback via "Strengthen Confidence" and "Increase Effectiveness" sections</li>
                        <li>Before rolling-it out, as a team agree by when you want to complete the reviews</li>
                        <li>Conduct a retrospective on how the 360 Feedback worked, Inspect and Adapt.</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <a href="#four" class="goto-next scrolly">Next</a>
</section>

<!-- Four -->
<section id="four" class="wrapper style1 special fade-up">
    <div class="container">
        <header class="major">
            <h2>Feedback 360 comes Loaded with Features</h2>
            <p>So that you can focus on providing quality feedback and leave the rest to us.</p>
        </header>
        <div class="box alt">
            <div class="row uniform">
                <section class="4u 6u(medium) 12u$(xsmall)">
                    <span class="icon alt major fa-area-chart"></span>
                    <h3>Visual &amp; Intuitive</h3>
                    <p>View a single feedback survey or how your feedback is trending across a time-range.</p>
                </section>
                <section class="4u 6u$(medium) 12u$(xsmall)">
                    <span class="icon alt major fa-comment"></span>
                    <h3>Start a Conversation</h3>
                    <p>Ask for clarification on any feedback and start a conversation on it, right away.</p>
                </section>
                <section class="4u$ 6u(medium) 12u$(xsmall)">
                    <span class="icon alt major fa-flask"></span>
                    <h3>Safe-Fail Experimentation</h3>
                    <p>Try asking feedback on different competencies or changing the questions to suit your needs.</p>
                </section>
                <section class="4u 6u$(medium) 12u$(xsmall)">
                    <span class="icon alt major fa-paper-plane"></span>
                    <h3>Swift and Direct</h3>
                    <p>Enables instant and direct pull-based feedback to truly help your team.</p>
                </section>
                <section class="4u 6u(medium) 12u$(xsmall)">
                    <span class="icon alt major fa-file"></span>
                    <h3>Fancy Reports</h3>
                    <p>Download clean, simple, concise reports to eliminate noise from your signals.</p>
                </section>
                <section class="4u$ 6u$(medium) 12u$(xsmall)">
                    <span class="icon alt major fa-lock"></span>
                    <h3>Safe and Secure</h3>
                    <p>Be assured that your data is safe and only accessible to the concerned person.</p>
                </section>
            </div>
        </div>
        <footer class="major">
            <ul class="actions">
                <li><a href="/survey/create" class="button">Give it a Spin</a></li>
            </ul>
        </footer>
    </div>
</section>

<!-- Five -->
<section id="five" class="wrapper style2 special fade">
    <div class="container">
        <header>
            <h2>Sounds Interesting?</h2>
            <p>Want to get updates from our side?</p>
        </header>
        <form method="post" action="/auth/subscribe" class="container 50%">
            <div class="row uniform 50%">
                <div class="8u 12u$(xsmall)"><input type="email" name="email" id="email" placeholder="Your Email Address" /></div>
                <div class="4u$ 12u$(xsmall)"><input type="submit" value="Subscribe" class="button special" /></div>
            </div>
        </form>
    </div>
</section>